/*
 * LibStringStack Copyright (c) 2017, James Bailie.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote 
 * products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stdio.h>

#include "stringstack.h"

void print( struct string *s )
{
   printf( "%s\n", s->str );
}

int main( int argc, char **argv )
{
   struct string *a, *b;

   a = string_make( NULL );

   string_append( a, 'o' );
   print( a );

   string_prepend( a, 'd' );
   print( a );

   string_concat( a, "g shit" );
   print( a );

   string_precat( a, "damn " );
   print( a );

   b = string_make( "foobar" );
   print( b );

   string_merge( a, b );
   print( a );

   string_precat( a,
      "a really long additional string longer than the free elements in the string so that we can"
      "test that case.  Additional sentences.  Hoopla hooray hookey hokey hoe.  That's what I know."
      "Is there any doubt in your mind?  I don't think so.  How could there be?  Only a cheeseburger." );
                      
   print( a );
}
