/*
 * LibYarb Copyright (c) 2017, James Bailie.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define YARB_RED 0
#define YARB_BLACK 1

#include <stdlib.h>
#include <syslog.h>
#include <stdarg.h>

union yarb_keyval
{
   void *ptr;
   float num;
};

struct yarb
{
   union yarb_keyval key, value;
   struct yarb *left, *right, *parent;
   unsigned char color;
};

struct yarb_list
{
   union yarb_keyval key, value;
};

struct yarb_stack
{
   int free, used;
   struct yarb **top, **values;
};

struct yarb_stack *yarb_make_stack();
struct yarb *yarb_stack_push( struct yarb_stack *, struct yarb * );

struct yarb *yarb_lookup( const struct yarb *, int ( * )( const union yarb_keyval, const union yarb_keyval ),
                          const union yarb_keyval );

struct yarb *yarb_insert( struct yarb *, int ( * )( const union yarb_keyval, const union yarb_keyval ),
                          void ( * )( union yarb_keyval ),
                          const union yarb_keyval, const union yarb_keyval );

struct yarb *yarb_delete( struct yarb *, int ( * )( const union yarb_keyval, const union yarb_keyval ),
                          void ( * )( union yarb_keyval, union yarb_keyval ),
                          const union yarb_keyval );

struct yarb *yarb_first( const struct yarb * );
struct yarb *yarb_last( const struct yarb * );

struct yarb *yarb_next( const struct yarb * );
struct yarb *yarb_previous( const struct yarb * );

struct yarb *yarb_traverse( const struct yarb *, void ( * )( struct yarb *, void * ), void *, int );
int yarb_destroy( struct yarb *, void ( * )( union yarb_keyval, union yarb_keyval ));

#define YARB_STACK_PUSH( _s_, _o_ ) ( ! ( _s_ )->free ? yarb_stack_push( _s_, _o_ ) : \
   ( ! ( _s_ )->used ? ( --( _s_ )->free, ++( _s_ )->used, *( _s_ )->top = _o_ ) : \
     ( ++( _s_ )->top, --( _s_ )->free, ++( _s_ )->used, *( _s_ )->top = _o_ )))

#define YARB_STACK_POP( _s_ ) ( !( _s_ )->used ? NULL : ( ++( _s_ )->free, --( _s_ )->used, \
   ((( _s_ )->top == ( _s_ )->values ) ? *( _s_ )->top : ( --( _s_ )->top, *(( _s_ )->top + 1 )))))

#define YARB_STACK_CLEAR( _s_ ) ( _s_ )->free += ( _s_ )->used; ( _s_)->used = 0; ( _s_ )->top = ( _s_ )->values
#define YARB_STACK_FREE( _s_ ) free(( _s_ )->values ); free(( _s_ ))
