.Dd Sat, Apr 22, 2023
.Dt ephemera 1
.Sh NAME
.Nm ephemera
.Nd SCGI Blog Server
.Sh SYNOPSIS
.Nm ephemera Oo -f Ao config_file Ac -m Ao max_conns Ac -u Ao user Ac -g Ao group Ac -i Ao \
interface Ac -p Ao port Ac -l Ao socket Ac -x Oc
.Sh DESCRIPTION
.Pp
Ephemera is an event-driven SCGI application server dedicated to serving-up
a single blog with no comment facility.
.Pp
Ephemera is for people who have their own hosts on which they can install
software, who know HTML5 and CSS, and who prefer working with text-based
tools.
.Pp
Posts are stored in a SQLite database that can be read into memory at
startup or accessed from the file system.
.Ss MANAGING CONTENT
You write your posts in HTML5.  You can put whatever elements you like into
your posts, but the database stores only the HTML.  If you want to
reference other resources, you will need to create web-visible directories
to hold those resources.
.Pp
There is no web interface for managing content because I would rather be
rolled in seal oil and exposed to polar bears than use web-based tools.
You manage the database with six munger(1) scripts that work with plain
text.  Five are command-line tools that can be used for one-off operations
or shell scripting.  The sixth is an interactive fullscreen database
editor.  The scripts send the server a SIGHUP to notify it to reload the
database.
.Pp
For example, you can add posts from remote hosts like this:
.Bd -literal -offset left
ssh user@host '/usr/local/bin/add.munger /path/to/db/ephemera.sqlite' < post.txt
.Ed
.Pp
My goodness.  That is a prime candidate for a shell alias.
.Pp
The munger scripts are located in %%PREFIX%%/bin and are documented
internally with comments.  All scripts require the path to the database
file to be passed as a command line argument.
.Pp
Ephemera serves up UTF-8 encoded web pages, but munger does not understand
UTF-8.  This means that you can use the munger scripts to manipulate UTF-8
articles, but the motion and search commands in edit.munger will move to
the wrong locations on lines with multibyte characters.  If you need to use
non-ASCII characters in your blog posts, use the HTML entities for those
characters.
.Pp
The five command-line scripts are named create.munger, add.munger,
replace.munger, delete.munger, and extract.munger.
.Pp
The sixth script, edit.munger, is an interactive console program to view,
add, delete, edit, and search for posts in the database.  The following
commands are available.
.Bl -tag -width '[backspace]'
.It k
.It j
Move the cursor up or down one line.  These commands can be preceded with a
repeat count.
.It [
.It ]
Move the cursor up or down one paragraph.  These commands can be
preceded with a repeat count.
.It [space]
.It [backspace]
Scroll the screen forward or backward one screenful.  These commands can be
preceded with a repeat count.
.It g
.It G
Move the cursor to the top or the bottom of the current screen.
.It 0
.It $
Move the cursor to the start or end of the current line.
.It l
.It h
Move the cursor forward or backward by one character.  These commands can be
preceded with a repeat count.
.It w
.It b
Move the cursor forward or backward by one word.  These commands can be
preceded with a repeat count.
.It / <pattern>
.It ? <pattern>
Search forward or backward in the current screen for a match on a regular
expression.  Searches wrap-around.  These commands can be preceded with
a repeat count.
.It n
.It N
Repeat the last pattern search in the same or the opposite direction.
These commands can be preceded with a repeat count.
.It q
Quit the database editor.
.It e
Extract the current post to a text file with the same name as the
post's database Id.
.It s
Search the database using the SQLite full text search interface.  Articles
containing matches are added to the post list in reverse chronological
order.
.It Control-l
Load the post list with all posts in reverse chronological order.
.It i
Toggle on or off the display of post Ids in the post list.
.It a
Add a new post to the database.  The editor specifed by the EDITOR
environment variable is run on an empty file.
.Pp
Insert the post's complete title on the first line.  Insert a blank line
after the title line.  The title is wrapped in an <h3> element when it is
sent to clients.
.Pp
Insert the post's body after the blank line.  Markup the body to be proper
HTML5.  Both the title and body are inserted into a left-floated div.  If
you include block elements in your post bodies, then you must make them
float left to render properly.  Alternately, you can set the display
property to inline-block. This is true of ol, ul, and pre elements.
.It d
Delete the current post.
.It [enter]
Load the current post into the viewer.  When the viewer
is onscreen, the following additional commands are available:
.Bl -tag -width '[enter]'
.It [enter]
Run the editor specified by the EDITOR environment variable on the current
post.
.It u
Update the database.  Do this when you exit from your editor if you want
to preserve your changes.
.It q
Return to the post listing.
.El
.El
.Ss CONFIGURATION
If it cannot allocate memory from the system, ephemera exits. You need to
set the maximum number of simultaneous connections with the -m option to a
value that is suitable for your host's resources.
.Pp
To configure ephemera:
.Bl -enum
.It
Set the server options in /etc/rc.conf appropriately for your system.
See SERVER OPTIONS.
.It
copy %%PREFIX%%/share/ephemera/ephemera.config to the location you specify
with the -f server option.  Edit the file.  Each setting is documented with
a comment.
.It
Configure your web server to forward requests for the resource you have
described with "path" in ephemera.config to the interface you have
described with "ephemera_flags" in /etc/rc.conf.
.It
Copy ephemera.css, the *.ttf files from %%PREFIX%%/share/ephemera to the
directory that you specified with "web_directory" in ephemera.config.
.It
Start your web server.  Start ephemera with:
.Bd -literal -offset left
service ephemera start
.Ed
.Pp
Customize ephemera.css.
.El
.Ss SERVER OPTIONS
The following command line options are available.  To use an option, insert
it into the value of the ephemera_flags variable in /etc/rc.conf.  For
example,
.Bd -literal -offset left
ephemera_enable="YES"
ephemera_flags="-u www -g www -l /var/run/ephemera.socket"
.Ed
.Bl -tag -width "-f"
.It -d
The -d option prevents the server from loading the article database into
memory.  By default, the server loads the article database into memory at
startup.
.It -f
The -f option specifies the path to the directory containing
ephemera.config.  This value defaults to /usr/local/etc.
.It -m
The -m option specifies the number of simultaneous connections the server
will accept.  The value defaults to 1024.
.It -u
.It -g
The -u and the -g options to specify the user and group of the server
processes.  Both values default to "nobody".  If you use
the -l option to make the server listen on a UNIX socket, then you must use
these options to ensure that ephemera runs with the same user or group
setting of the web server, or the webserver will not be able to connect to
the socket.
.It -p
The argument to the -p option specifies the port to listen on.  The port
defaults to 4000.
.It -i
By default, ephemera accepts connections on all interfaces it can find
capable of IPv4 or IPv6.  The -i option overrides this behavior to limit
drood to accepting connections from a specified interface only.  Pass the
IP address of the desired interface as argument.
.It -l
The -l option specifies the path to a UNIX-domain socket for the server to
listen on.  Use a UNIX socket instead of the loopback interface if the web
server and ephemera run on the same host.  Using the loopback address
unnecessarily interposes the TCP/IP stack between the two servers, which
degrades performance.
.Pp
The -l option cannot be present on the command line if the -p or -i option
is also present.  The server creates the socket on startup. The owner and
group of the socket is changed to the values of the -u and -g options.  The
permissions of the socket are set to srwxrwx---.
.It -x
The -x option prevents ephemera from becoming a daemon.  The
server runs in the foreground of the terminal where it is started. The
server is stopped with signals (ie., Control-C).
.El
.Sh AUTHORS
.An James Bailie Aq bailie9@icloud.com
.br
http://www.mammothcheese.ca
