/*
 * Ephemera Copyright (c) 2014, James Bailie.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote
 * products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define STACK_PUSH( _s_, _o_ ) { if (( _s_ )->free )\
   {\
      if (( _s_ )->used ) ++( _s_ )->top;\
      --( _s_ )->free;\
      ++( _s_ )->used;\
      *( _s_ )->top = ( _o_ );\
   }\
   else stack_push( _s_, _o_ ); }

#define STRING_APPEND( _s_, _c_ ) { if (( _s_ )->free )\
   {\
      --( _s_ )->free;\
      ++( _s_ )->used;\
      *( _s_ )->top++ = _c_;\
      *( _s_ )->top = '\0';\
   }\
   else string_append( _s_, _c_ ); }

#define STRING_TRUNCATE( _s_ ) if (( _s_ )->used ) { ( _s_ )->free += ( _s_ )->used; ( _s_ )->used = 0; *( _s_ )->str = '\0'; ( _s_ )->top = ( _s_ )->str; }
#define stack_inc 64
#define string_inc 1024

struct stack 
{
   int used, free;
   char **values, **top;
};

struct string
{
   int free, used;
   char *top;
   char *str;
};

void *memory( int );

struct string *make_string();
void string_append( struct string *, char );
char *str_dup( char *, int );
void string_free( struct string * );

struct stack *make_stack();
void stack_push( struct stack *, void * );
struct stack *make_stack();
void stack_free( struct stack * );
char *stack_pop( struct stack * );
