/*
 * LibMessage Client Copyright (c) 2020, James Bailie.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/*
 * "make echoclient"
 */

#include "messageclient.h"

int read_line( unsigned char *buffer, int size )
{
   unsigned char c, *ptr;
   int r, count;

   count = 0;
   ptr = buffer;

   for( ; ; )
   {
      if (( r = read( STDIN_FILENO, &c, 1 )) <= 0 )
      {
         if ( r < 0 )
         {
            fprintf( stderr, "echoclient: read(): %s\n", strerror( errno ));
            return r;
         }

         return count;
      }

      ++count;
      *ptr++ = c;
      *ptr = '\0';

      if ( c == 10 || c == 13 || count == size - 1 )
         break;
   }

   return count;
}

int main( int argc, char **argv )
{
   struct mc_ssl *conn;
   unsigned char buffer[ 1024 ], *response;
   int len;

   if ( argc < 3 )
   {
      fputs( "usage: echoclient <address> <port>\n", stderr );
      exit( 1 );
   }

   if ( mc_init() )
      exit( 1 );

   /*
    * We don't bother to verify the hostname because
    * are an example program.
    */

   if (( conn = mc_connect_to_server( argv[ 1 ], argv[ 2 ], 0 )) == NULL )
   {
      fputs( mc_error, stderr );
      exit( 1 );
   }

   while(( len = read_line( buffer, sizeof( buffer ))) > 0 )
   {
      if ( mc_send_message( conn, len, buffer ))
      {
         fputs( mc_error, stderr );
         exit( 1 );
      }

      if (( len = mc_read_message( conn, &response )) <= 0 )
      {
         if ( len < 0 )
            fputs( mc_error, stderr );

         exit( 1 );
      }

      fwrite( response, 1, len, stdout );
      fflush( stdout );
      free( response );
   }

   mc_close_connection( conn );
   mc_deinit();
   return 0;
}
