.Dd Thu Nov 13, 2025
.Dt libmessageclient 3
.Sh NAME
.Nm libmessageclient
.Nd Client Library for libmessage(3)
.Sh SYNOPSIS
.Nm #include <messageclient.h>
.Nm -I/usr/local/include -L/usr/local/lib -lmessageclient -lcrypto -lssl
.Sh DESCRIPTION
libmessageclient provides reentrant, blocking-IO code to communicate with
LibMessage servers.
.Ss USAGE
The library provides 9 functions.
.Bd -literal -offset left
char mc_error[ 256 ];

SSL_CTX *ctx;

struct mc_ssl {
   SSL *ssl;
   int fd;
};

int mc_init_tls( int );
void mc_deinit_tls();

int mc_set_max_message( unsigned int );

struct mc_ssl *mc_connect_to_server( char *, char *, int );
void mc_close_connection( struct mc_ssl * );

int mc_read_frame( struct mc_ssl *, unsigned char *, unsigned char );
int mc_read_message( struct mc_ssl *, unsigned char ** );

int mc_send_frame( struct mc_ssl *, unsigned char, unsigned int, unsigned char * );
int mc_send_message( struct mc_ssl *, unsigned int, unsigned char * );
.Ed
.Pp
Do not define any other global symbol beginning with the 3 characters
\'mc_' because the library reserves that namespace.
.Ss MC_INIT_TLS()
Use mc_init_tls() to initialize OpenSSL before using any of the other
functions.  Note that this function sets SIGPIPE to be ignored.
.Bd -literal -offset left
int mc_init_tls();
.Ed
.Pp
On success, the function returns 0.
.Pp
On error, the function returns -1 and writes an error message into mc_error.
.Ss MC_DEINIT_TLS()
Use mc_deinit_tls() to free the OpenSSL context when you are finished using
the library.
.Bd -literal -offset left
void mc_deinit_tls();
.Ed
.Ss MC_CONNECT_TO_SERVER()
Use mc_connect_to_server() to establish a connection to a LibMessage server.
.Bd -literal -offset left
struct mc_ssl *mc_connect_to_server( char *hostname, char *port, int ignore );
.Ed
.Pp
The hostname argument is a string representing the hostname or IP address
of the host on which the server is running.
.Pp
The port argument is a string representing the port on which the server is
listening.
.Pp
The ignore argument indicates whether or not to ignore a mismatch between
the hostname and the hostname on the server's certificate.  This is useful
for debugging over the loopback interface.
.Pp
On success, the function returns a pointer to a struct mc_ssl.
.Pp
On failure, the function returns NULL and writes an error message into
mc_error.
.Ss MC_CLOSE_CONNECTION()
Use mc_close_tls_connection() to close a connection.
.Bd -literal -offset left
void mc_close_tls_connection( struct mc_ssl * );
.Ed
.Pp
The function shuts down the TLS connection, closes the underlying
descriptor, and frees the struct mc_ssl pointed to by the argument.
.Ss MC_SET_MAX_MESSAGE
Use mc_set_max_message() to set the maximum message size that both server and
client use. The default maximum message size is 262128 bytes.
.Bd -literal -offset left
unsigned int mc_set_max_message( unsigned int max );
.Ed
.Pp
The function returns 0 if max is not a multiple of the internal frame payload
size, which is 32766. In this case, the maximum message size is unchanged.
Otherwise, the function returns the new maximum message size.
.Ss MC_READ_FRAME()
Use mc_read_frame() to read a single frame from a server.  If you want to
timeout the read, use setsockopt() to place a timeout on the underlying
socket (the fd member of the struct ssl).
.Bd -literal -offset left
int mc_read_frame( struct mc_ssl *conn, unsigned char *buffer, unsigned char *final );
.Ed
.Pp
The conn argument is the pointer returned by mc_connect_to_server().
.Pp
The buffer argument is a character array of 32766 elements.
.Pp
The final argument is a pointer to an unsigned character.
.Pp
On success, the function reads an incoming frame's payload into buffer, writes
the high-order bit of the frame into the high-order bit of final, and
returns the number of characters read.
.Pp
The function returns 0 for an empty frame.
.Pp
On error, the function returns -1 and writes an error message into
mc_error.
.Pp
On EOF, the function returns -2.
.Ss MC_READ_MESSAGE()
Use mc_read_message() to read a complete message from a server.  If you
want to timeout the read, use setsockopt() to place a timeout on the
underlying socket (the fd member of the struct ssl).
.Bd -literal -offset left
int mc_read_message( struct mc_ssl *conn, unsigned char **buffer );
.Ed
.Pp
The conn argument is the pointer returned by mc_connect_to_server().
.Pp
The buffer argument is a pointer to a character pointer.
.Pp
On success, the function reads an incoming messages's payload into a
dynamically-allocated buffer that you are responsible for freeing, places
a pointer to that buffer in *buffer, and returns the number of characters read.
.Pp
The function returns 0 for an empty frame.  *buffer is set to NULL.
.Pp
The function returns -1 on error and writes an error message into mc_error.
*buffer is set to NULL.
.Pp
On EOF, the function returns -2. *buffer is set to NULL.
.Ss MC_SEND_FRAME()
Use mc_send_frame() to send a frame to a server.
.Bd -literal -offset left
int mc_send_frame( struct mc_ssl *conn, unsigned int len, unsigned char *buffer );
.Ed
.Pp
The conn argument is the pointer returned by mc_connect_to_server();
.Pp
The buffer argument is a character array containing frame data.
.Pp
The len argument is the length of the data in buffer.  The length
must be > 0 and <= 32766.
.Pp
On success, the function returns 0.
.Pp
If the peer has closed the connection, the function returns -2.
.Pp
On other errors, the function returns -1 and writes an error message into
mc_error.
.Ss MC_SEND_MESSAGE()
Use mc_send_message() to send a complete message to a server.
.Bd -literal -offset left
int mc_send_message( struct mc_ssl *conn, unsigned int len, unsigned char *buffer );
.Ed
.Pp
The conn argument is the pointer returned by mc_connect_to_server();
.Pp
The buffer argument is a character array containing message data.
.Pp
The len argument is the length of the data in buffer.  The length
must be > 0 and <= 262128.
.Pp
On success, the function returns 0.
.Pp
If the peer has closed the connection, the function returns -2.
.Pp
On other errors, the function returns -1 and writes an error message into
mc_error.
.Sh AUTHORS
.An James Bailie Aq bailie9@icloud.com
.br
mammothcheese.ca
