#include "stacks.mm"

(declare t (table))
(declare n 1000000)

(declare insert
   (lambda (start end)
      (when (<= start end)
         (hash t start start)
         (insert (+ start 1) end))))

(println "Hash table insertion test: " n " items.")
(println (date))
(insert 1 n)
(println (date))

(declare delete
   (lambda (start end)
      (when (<= start end)
         (unhash t start)
         (delete (+ start 1) end))))

(println "Hash table deletion test: " n " items.")
(println (date))
(delete 1 n)
(println (date))
