; Copyright (c) 2026, James Bailie <jimmy@mammothcheese.ca>.
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
; 
;     * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
;     * Redistributions in binary form must reproduce the above copyright
; notice, this list of conditions and the following disclaimer in the
; documentation and/or other materials provided with the distribution.
;     * The name of James Bailie may not be used to endorse or promote 
; products derived from this software without specific prior written permission.
; 
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
; ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
; CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.

(declare token "")
(declare type "empty")
(declare escaping 0)

(declare path_string "")
(declare idx 0)

(declare parent 0)
(declare parents (stack))

(declare ps_rx (regcomp "\\\\[^\\\\]+$"))
(declare sql 0)
(declare result 0)

(declare make_cdata 
   (lambda (item)
      (bind idx (+ idx 1))

      (when (stringp (bind result (sqlite_bind sql 1 (stringify idx))))
         (die result))
      
      (when (stringp (bind result (sqlite_bind sql 2 (concat path_string "\\"))))
         (die result))
      
      (when (stringp (bind result (sqlite_bind sql 3 item)))
         (die result))
      
      (when (stringp (bind result (sqlite_bind sql 4 (stringify parent))))
         (die result))
      
      (when (stringp (bind result (sqlite_step sql)))
         (die result))
      
      (when (stringp (bind result (sqlite_reset sql)))
         (die result))))
   
(declare make_open 
   (lambda (name)
      (bind idx (+ idx 1))
      (bind path_string (concat path_string "\\" name))
      
      (when (stringp (bind result (sqlite_bind sql 1 (stringify idx))))
         (die result))
      
      (when (stringp (bind result (sqlite_bind sql 2 path_string)))
         (die result))
      
      (when (stringp (bind result (sqlite_bind sql 3 "")))
         (die result))
      
      (when (stringp (bind result (sqlite_bind sql 4 (stringify parent))))
         (die result))
      
      (when (stringp (bind result (sqlite_step sql)))
         (die result))
      
      (when (stringp (bind result (sqlite_reset sql)))
         (die result))
      
      (push parents parent)
      (bind parent idx)))
   
(declare make_close 
   (lambda ()
      (bind parent (pop parents))
      (bind path_string (substitute ps_rx "" path_string))))
   
(declare make_item 
   (lambda (type item)
      (cond ((eq type "cdata") (make_cdata item))
            ((eq type "open")  (make_open  item))
            ((eq type "close") (make_close)))))
   
(declare parse_line
   (lambda (chars)
      (when (used chars)
         (let ((c (shift chars)))
            
            (cond ((eq type "empty")
                   (if (eq c "[")
                     (bind type "open")
   
                     (if (eq c "]")
                        (bind type "close")
   
                        (bind type "cdata")
                        (if (eq c "\\")
                           (bind escaping 1)
                           (bind token c)))))
      
                     ((eq type "open")
                      (if (not (eq c "["))
                          (bind token (concat token c))
      
                          (make_item type token)
                          (bind type "empty")
                          (bind token "")))
      
                     ((eq type "close")
                      (when (eq c "]")
                          (make_item type token)
                          (bind type "empty")
                          (bind token "")))
      
                     ((eq type "cdata")
                      (if (and (not escaping)
                               (or (eq c "]") (eq c "[")))
                        (progn
                           (when token (make_item type token))
                           (bind token "")
                           (bind type (if (eq c "]") "close" "open")))
      
                        (if (and (not escaping) (eq c "\\"))
                           (bind escaping 1)
      
                           (bind escaping 0)
                           (bind token (concat token c))))))
   
            (parse_line chars)))))

(declare parse 
   (lambda (line)
      (if (and (not line) token)
         (make_item type token)
         (parse_line (explode line)))))

; See if the user has provided us a filename for the database.
; Otherwise use "tsml.db".

#include "options.mm"

(getopt 0)
(declare file 0)
(unless (bind file (lookup options "f"))
   (bind file "tsml.db"))

; Read from the first filename specified on the command-line or from stdin.
; The call to (getopt) above has left the argument pointer pointing to the
; last option, if any, or to the script name.  We need only call (next)
; once to get the name of the first command-line argument.

(when (next)
   (redirect 0 (current) 0))
   
; Open the database.

(when (stringp (bind result (sqlite_open file)))
   (die result))

(when (stringp (bind result (sqlite_exec (concat
   "CREATE TABLE TSML ( 'index' INTEGER PRIMARY KEY, "
   "'path' TEXT, 'data' TEXT, parent INTEGER )"))))
   (die result))

(when (stringp (bind result (sqlite_prepare "INSERT INTO TSML VALUES ( ?1, ?2, ?3, ?4 );")))
   (die result))

(bind sql result)

(when (stringp (bind result (sqlite_exec "BEGIN TRANSACTION")))
   (die result))

(declare parse_lines
   (lambda (line)
      (parse line)
      (when line 
         (parse_lines (getline)))))

(parse_lines (getline))

(when (stringp (bind result (sqlite_exec "COMMIT TRANSACTION")))
   (die result))

(when (stringp (bind result (sqlite_exec "CREATE INDEX pindex ON TSML ( parent )")))
   (die result))

(sqlite_close)
