; Copyright (c) 2026, James Bailie <jimmy@mammothcheese.ca>.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
;
;     * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
;     * Redistributions in binary form must reproduce the above copyright
; notice, this list of conditions and the following disclaimer in the
; documentation and/or other materials provided with the distribution.
;     * The name of James Bailie may not be used to endorse or promote
; products derived from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
; ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
; CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.

(declare get_index
   (lambda (path idx item_idx items)
      (if (< (used items) 2)
         -1
         (letn ((path (concat path "\\" (index items item_idx)))
                (sql (concat "SELECT \"index\" FROM TSML "
                             "WHERE parent = " (if (numberp idx) (stringify idx) idx)
                             " AND path = '" path "' ORDER BY \"index\" "
                             "LIMIT 1 OFFSET " (stringify (- (index items (+ item_idx 1)) 1))))
                (result (sqlite_exec sql)))

            (cond ((stringp result) (die result))
                  ((not (used result)) -1)

                  ((eq 2 (- (used items) item_idx)) (index result 0))

                  (1 (get_index path (index result 0) (+ 2 item_idx) items)))))))

(declare get_content
   (lambda (data items)
      (letn ((idx (if (eq 1 (length items))
                      (index items 0)
                      (get_index "" 0 0 items)))
             (sql (concat "SELECT " (if data "\"index\",path,data" "\"index\",path") " FROM TSML "
                          "WHERE parent = " (if (numberp idx) (stringify idx) idx) 
                          " ORDER BY \"index\""))
             (result (sqlite_exec sql)))

         (cond ((stringp result) (die result))
               ((not (used result)) 0)
               (1 result)))))

(declare get_elements
   (lambda (tag items)
      (letn ((idx (if (eq 1 (length items))
                      (index items 0)
                      (get_index "" 0 0 items)))
             (sql (concat "SELECT \"index\",path FROM TSML WHERE parent = " (stringify idx) " AND path "
                           (if tag (concat "LIKE '%" tag "'") "NOT LIKE '%\\'")
                           " ORDER BY \"index\""))
             (result (sqlite_exec sql)))

         (cond ((stringp result) (die result))
               ((not (used result)) 0)
               (1 result)))))

(declare get_data
   (lambda (data items)
      (letn ((idx (get_index "" 0 0 items))
             (sql (concat "SELECT " (if data "data" "\"index\"") " FROM TSML "
                          "WHERE parent = " (if (numberp idx) (stringify idx) idx)
                          " AND path LIKE '%\\' ORDER BY \"index\""))
             (result (sqlite_exec sql)))

         (cond ((stringp result) (die result))
               ((not (used result)) 0)
               (1 result)))))

(declare get_data_segment
   (lambda (idx)
      (letn ((sql (concat "SELECT data FROM TSML WHERE \"index\" = "
                          (if (numberp idx) (stringify idx) idx)))
             (result (sqlite_exec sql)))

         (cond ((stringp result) (die result))
               ((not (used result)) 0)
               (1 (index result 0))))))
