.Dd Fri Dec 1, 2017
.Dt TSML 5
.Sh NAME
.Nm Tree-Structure Markup Language
.Nd alternative to XML and SML.
.Sh DESCRIPTION
TSML describes the structure of UTF-8 documents.  No means is provided to
describe which trees are valid expressions for any particular application
of the language.  There is no versioning of TSML.  This document describes
the one-and-only version of TSML.  If you create a format derived from TSML
please call it something else.  TSML is hereby licensed gratis to everyone
forever for any purpose.
.Ss ELEMENTS AND TAGS
TSML documents consist of two types of lexical components:  tags and data.
Tags are either open or close tags.  Data is everything not a tag.
The structural components of TSML documents are called elements.  Each
element is described by one open tag and one identically-named or anonymous
close tag that occurs in the document subsequent to the open tag.  Elements
may contain a mixture of data and other elements to form tree-structure.
Nested elements must exist completely inside one direct parent element.
.Pp
Open tags have the form:
.Bd -literal -offset left
[<name>[
.Ed
.Pp
Open tags begin and end with a single byte of value 91 that represents the
open square bracket in UTF-8.  The sequence of bytes between the
brackets is the name of the element.  Names are case-sensitive.  The name
may be any sequence of byte values in which 0, 91, 92, and 93 do not appear
that is less than 256 bytes in length.  91, 92, and 93, are the UTF-8
encodings for the characters [, \\, and ].  Note that whitespace is
permissable in element names.
.Pp
Close tags have the form:
.Bd -literal -offset left
]<name>]
.Ed
.Pp
Close tags begin and end with a single byte of value 93 that represents the
close square bracket in UTF-8.  The name component of close tags is
optional and if present, must be the exact same sequence of byte values as
the name of the corresponding open tag.
.Pp
A TSML document must have a single top-level element that contains all
other document content.  The names of all elements are application
specific.  None is specified by this document.  Elements may be empty.
The following is an example of an empty document:  
.Bd -literal -offset left
[TSML[]]
.Ed
.Ss DATA
Data are any sequence of byte values excluding 0 in which any occurrence of
the values 91, 92, and 93 are preceded by a byte of value 92.  In other
words, to insert [, \\, or ] into data, escape these characters with a
backslash.  Although it is not necessary, other characters may be escaped
by preceding them with a backslash.  A TSML parser must remove the escaping
backslash from all such character sequences before returning data to an
application.
.Pp
Beyond escape-processing, a TSML parser must not modify TSML element data
before returning it to an application.
.Pp
There is no mechanism to embed comments into TSML documents.  Users define
their own application specific schema and can define their own comment
elements:
.Bd -literal -offset left
[comment[This is a comment.]]
.Ed
.Pp
.Ss EXAMPLE
An example TSML document follows.
.Bd -literal -offset left
[News Feed[

   [Source[
      [Title[Source Title]]
      [Link[Source Link]]
      [Description[Source Description]]
   ]]

   [Item[
      [Title[Item 1]]
      [Link[Link 1]]
      [Description[Description 1]]
   ]]

   [Item[
      [Title[Item 2]]
      [Link[Link 2]]
      [Description[Description 2]]
   ]]

]News Feed]
.Ed
.Sh AUTHORS
.An James Bailie Aq bailie9@icloud.com
.br
http://mammothcheese.ca
