.Dd Wed Dec 06, 2017
.Dt tsmlquery 3
.Sh NAME
.Nm Munger module for TSML databases
.Nd queries structure and content.
.Sh DESCRIPTION
The tsmlquery.munger module provides 4 functions to discover the structure
and content of databases created by tsml2sqlite(1).  The tsmlquery.munger
module is installed in (libdir).
.Pp
The following is an example TSML document that is queried by example code.
.Bd -literal -offset left
[News Feed[

   [Source[
      [Title[Source Title]]
      [Link[Source Link]]
      [Description[Source Description]]
   ]]

   [Item[
      [Title[Item 1]]
      [Link[Link 1]]
      [Description[Description 1]]
   ]]

   [Item[
      [Title[Item 2]]
      [Link[Link 2]]
      [Description[Description 2]]
   ]]

]News Feed]
.Ed
.Ss (get_content db data (items))
returns a list of records from the database that represent the immediate
children of a specified element.  The first argument is a SQLite database
object.  The second argument is a boolean flag specifying if the function
should return the data fields.
.Pp
The element to be queried is specified by the index field of its record or
by a series of pairs of element names and ordinal positions.  If only one
argument follows the second argument, the third argument is interpreted as
the index of the element to be queried.  If more than 1 argument follows
the second argument, those arguments are interpreted as path pairs.  Each
pair specifies one element in the path to the element to be queried.  The
first item of each pair is a string naming an element.  The second item is
a number that specifies a particular instance of the named element in its
parent.  Instances are numbered from 1.
.Pp
If the specified element does not exist in the database, the empty list is
returned.  Otherwise, a list of sublists is returned.  If the second
argument is true, sublists contain 3 strings:  a child's index, its path,
and its data.  If the second argument is false, the data elements are
omitted.
.Pp
The following example queries a database created from the example TSML
document.
.Bd -literal -offset left
(load (join "/" (libdir) "tsmlquery.munger"))

(when (stringp (setq db (sqlite_open "tsml.db")))
   (die db))

(foreach println (get_content db 0 "News Feed" 1))
.Ed
.Pp
The output from the program follows.  Note that the data children of the
"News Feed" element are the whitespace between the second level elements.
The whitespace includes newlines.  For visual clarity, we do not ask for
the data fields in the query.
.Bd -literal -offset left
("2" "\\News Feed\\")
("3" "\\News Feed\\Source")
("14" "\\News Feed\\")
("15" "\\News Feed\\Item")
("26" "\\News Feed\\")
("27" "\\News Feed\\Item")
("38" "\\News Feed\\")
.Ed
.Ss (get_elements db tag (items))
returns a list of the records that represent elements named by a specified
tag that are direct children of a specified element.  The first argument is
a SQLite database object.  The second argument is the desired tag.  The
arguments after the second argument are interpreted in the same manner as
the arguments after the second argument for get_content.
.Pp
If get_elements does not find data to satisfy the query, the function
returns the empty list.  Otherwise, get_data returns a list of lists.  Each
sublist contains 2 strings.  If the second argument names a tag, the first
string is the index for one element record with that tag name.  If the
second argument is a false value, the first string is the index of one
element record regardless of its tag name.  The second string is the path
of the element whose index is the first string.
.Pp
The following example queries a database created from the example TSML
document.
.Bd -literal -offset left
(load (join "/" (libdir) "tsmlquery.munger"))

(when (stringp (setq db (sqlite_open "tsml.db")))
   (die db))

(foreach println (get_elements db 0 "News Feed" 1))
(newline)

(foreach println (get_elements db "Item" "News Feed" 1))
.Ed
.Pp
The output from the program follows.  The first invocation of get_elements
returns the records of all the elements that are direct children of "News Feed".
The second invocation returns the records of the elements named "Item" that
are direct children.
.Bd -literal -offset left
("3" "\\News Feed\\Source")
("15" "\\News Feed\\Item")
("27" "\\News Feed\\Item")

("15" "\\News Feed\\Item")
("27" "\\News Feed\\Item")
.Ed
.Ss (get_data db data (items))
returns a list of all the document data from records that are immediate
children of a specified element.  The first argument is a SQLite database
object.  The second argument is a boolean flag.  The arguments after the
second argument are interpreted in the same manner as the arguments after
the second argument for get_content.
.Pp
If get_data cannot find data to satisfy the query, get_data returns the
empty list.  Otherwise, get_data returns a list of lists.  Each sublist
contains a string.  If the second argument is true, the string is data for
one data record.  If the second argument is false, the string is the index
of one data record.
.Pp
The following example queries a database created from the example TSML
document.
.Bd -literal -offset left
(load (join "/" (libdir) "tsmlquery.munger"))

(when (stringp (setq db (sqlite_open "tsml.db")))
   (die db))

(println (concat (get_data db 1 "News Feed" 1 "Source" 1 "Title" 1)))
(println (concat (get_data db 1 "News Feed" 1 "Source" 1 "Link" 1)))
(println (concat (get_data db 1 "News Feed" 1 "Source" 1 "Description" 1)))
(newline)

(for (((setq n 1) (setq item (get_data db 1 "News Feed" 1 "Item" n "Title" 1)))
      (item)
      ((newline) (inc n) (setq item (get_data db 1 "News Feed" 1 "Item" n "Title" 1))))

   (println (concat item))
   (println (concat (get_data db 1 "News Feed" 1 "Item" n "Link" 1)))
   (println (concat (get_data db 1 "News Feed" 1 "Item" n "Description" 1))))
.Ed
.Pp
The output from the program follows.
.Bd -literal -offset left
Source Title
Source Link
Source Description

Item 1
Link 1
Description 1

Item 2
Link 2
Description 2
.Ed
.Ss (get_data_segment db index)
returns one segment of document data.  The first argument is a SQLite
database object.  The second argument is the value of the index field of a
database record.  The second argument can be expressed as a number or a
string.  The function returns the data of the specified record as a string.
.Sh AUTHORS
.An James Bailie Aq jimmy@mammothcheese.ca
.br
http://www.mammothcheese.ca
