.Dd Sat Jan 03, 2026
.Dt nellie 1
.Sh NAME
.Nm nellie
.Nd Screenplay Formatter
.Sh SYNOPSIS
.Nm nellie Oo -a Oc Oo -n Oc Oo -o Oc Oo -b Oc Oo -t Oc Oo -i Oc Oo -d <scenelist> Oc Oo -c | -e Oc Oo <infile> Oo <outfile> Oc Oc
.Sh DESCRIPTION
Nellie converts a marked-up text document into a formatted screenplay
expressed as a PDF or an ePub.
.Pp
Nellie reads from stdin or from a single file specified on the command line
and writes to stdout or to another file specified on the command line.  To
specify an output file without an input file, specify an input file of '-'.
If the input document is malformed, nellie exits without explanation.
.Pp
Nellie expects its input stream to be encoded as UTF-8.
.Pp
Nellie embeds an open source courier typeface into PDFs.  Nellie's PDFs
render the Unicode character sets that the fonts support.  These are
sufficient to support European languages that use alphabets derived from
the Latin alphabet.
.Pp
Nellie understands Tree Structure Markup Language.  TSML is a generic
markup language described in tsml(5).  TSML is designed to be
machine-friendly rather than human-friendly.  Nellie uses a simple TMSL
scheme to classify paragraphs by type and to define document metadata.
.Pp
As a convenience, Nellie also converts a human-friendly markup language
into TSML (the -c option).  See the section of this manual titled MARKUP
LANGUAGE for details.
.Pp
.Ss OPTIONS
.Bl -tag -width '-x'
.It -a
causes nellie to creates PDFs for A4 size paper.  By default, nellie
creates PDFs for US Letter size paper.
.It -n
turns on scene numbering.
.It -o
Turns off emboldening of act headings and title pages for PDFs only.
.It -b
Turns off emboldening of scene headings for PDFs only.
.It -t
Turns off emboldening of shot headings for PDFs only.
.It -d
specifies a list of scenes to include in the output.  By default all scenes
are included.  If present on the command line , -d must be
followed by a list of scene numbers or scene number ranges separated by
commas:
.Bd -literal -offset left
nellie -d 2-10,23,30,53-55 <infile> <outfile>
.Ed
.Pp
The first number of a range must be less than or equal to the second number.
Items in the list do not have to be in document order. The specified
scenes are always output in document order. If you specify scenes more than
once explicitly or in overlapping ranges, the duplicate scenes are ignored.
.It -e
causes nellie to convert TSML input into an ebook hierarchy in a directory
named "ebook" that is a sub-directory of the current directory or a
sub-directory of the directory specified by the second command line
argument.
.It -i
causes nellie to add markup for cover images in EPUBS. See the section
titled EPUB for details.
.It -c
causes nellie to produce TSML output from Nellie's markup language input.
When -c is present on the command line, the -d option is ignored.
.El
.Ss TSML
A example TSML screenplay follows.
.Bd -literal -offset left
[y[
[m[
  [t[ TITLE 1;;TITLE 2 ]]
  [a[ Author 1; Author 2 ]]
  [c[ Contact 1; Contact 2 ]]
  [r[ Revision 1; Revision 2 ]]
  [w[ Watermark1; Watermark 2 ]]
]m]
[v[ ACT 1 ]]
[s[ INT. DINER. ]]
[a[ Our hero eats a cheeseburger. ]]
[a[ A man nearby talks to a salt cellar. ]]
[c[ MAN ]]
[p[ (with affection) ]]
[d[ You make lunch worth eating.  Where can I find such magnificent food
enhancing magic as you? ]]
[i[ This is an indented dialogue paragraph. ]]
]y]
.Ed
.Ss ELEMENTS
All elements have names of a single letter.  The toplevel element is named
\'y'.  It contains one or more instances of the following child elements.
.Pp
.Bl -tag -width 't'
.It 'm'
Nellie extracts from the children of the 'm' element the data to use in the
screenplay's title page and in the PDF Info dictionary.  To specify that
the text in these elements be formatted into multiple lines, separate the
data for each line from the others with a semicolon.  To insert a blank line
between lines, insert 2 contiguous semicolons.  To insert a semicolon into
the data, insert a tilde '~' instead. It will be replaced with a semicolon
by the formatter.
.Bd -literal -offset
[t[Title;;Subtitle]]
.Ed
.Bl -tag -width 't'
.It 't'
specifies the title of the screenplay.  Titles are formatted in boldface.
.It 'a'
specifies the authors.  If you want a 'By' line, add it yourself to the
beginning of the authors.
.It 'c'
specifies contact information.  All occurrences of the 3 characters "(C)"
are replaced with the copyright symbol.
.It 'r'
specifies revision information.  To insert the current date, make one of
the revision lines $D by itself.  To insert the manuscript word count,
start one of the revision lines with $W.  If you use $W by itself, the word
count will be followed with "WORDS" in English. If you prefer a different
text, follow $W with the desired text.  To insert the page count, start
one of the revision lines with $P.  If you use $P by itself, the page
count will be followed with "PAGES" in English.  If you prefer a different
text, follow $P with the desired text.
.It 'w'
specifies watermark text to be added underneath the text on each page.  All
occurrences of the 3 characters "(C)" are replaced with the copyright
symbol.  The specified lines are centered, rotated left, and rendered at 60
points with 90% opacity. The watermark is not a PDF annotation and cannot
be removed or edited by tools that operate on annotations.
.It 'l'
specifies the language of the input document as a BCP 47 country code.
Nellie only accesses this element when generating ebooks. The value
defaults to 'en' (English).
.It 'y'
specifies a copyright message to be added to the title pages of epubs. It
should contain the year, a comma, and the name of the copyright owner. You
can include an email address or web URL after another comma, but beware
that all text is formatted onto a single line. Nellie will precede
the copyright information with the text ' Copyright' and the c-in-circle
copyright symbol. If the 'y' element is missing from the metadata, no
copyright message is added to epubs.
.El
.Pp
The 'm' element should only appear once in a document.  If you provide
multiple instances, each instance's data supersedes the data in preceding
instances.  The 5 child elements should only appear once each inside 'm'.
If you provide multiple instances, the data in each instance supersedes
data the data in preceding instances.  If you do not provide the 't', 'a',
\'c', or 'r' elements, placeholder data is used. Watermarks are optional.
.It 'v'
provides the content of a centered, boldface heading line separated from
the rest of the screenplay with a blank line before and after the centered
line.  The 'v' element is intended for use in creating act headings, but
you can place any content that you like in these elements.
.Pp
If the content of a 'v' element wraps onto multiple lines, nellie discards
all lines after the first.  Nellie pushes 'v' headings to new pages.
.It 'e'
provides the content of a centered, boldface heading separated from
the rest of the screenplay with a blank line before and after the centered
line, but 'e' elements are not widow-controlled.  The 'e' element is
intended for use in creating 'The End' markers at the end of screenplays.
End markers are useful because screenplays do not describe the page total
in title pages or page headers.
.Pp
If the content of an 'e' element wraps onto multiple lines, nellie discards
all lines after the first.
.It 's'
provides the content of a scene heading.  Nellie formats Scene headings in
boldface.  To add scene numbers, include the -n option on the command line.
.It 'o'
provides the content of a shot heading.  Shot headings are formatted
similarly to scene headings.
.Pp
When scene numbers are turned on, shots are lettered.
(eg., 2A).
.Pp
When the -d option provides a scene list, shots are considered to be part
of the scene started by the preceding scene heading.
.It 'a'
provides the content of an action paragraph.  To force line breaks in
any non-metadata paragraph, insert the bar '|' character.
.It 'c'
provides the content of a character cue that introduces a centered dialogue
block.
.It 'f'
provides the content of a character cue that introduces a left-aligned
dialogue block.
.It 'r'
provides the content of a character cue that introduces a right-aligned
dialogue block.
.It 'p'
provides the content of a parenthetical direction for dialogue.  You must
provide the parentheses characters in the content.  Parentheticals cannot
appear inside other elements.  To place a parenthetical inside a paragraph
of dialog, break up the dialogue into 2 paragraphs:
.Bd -literal -offset left
[c[JAMES]]
[p[(to Calvin)]]
[d[I don't know if I trust you.]]
[p[(to himself)]]
[d[I know I don't.]]
.Ed
.It 'd'
provides the content of a dialogue paragraph.  Elements with only
whitespace data are ignored.
.It 'i'
provides the content of an indented dialogue paragraph.  Insert one or more
whitespace characters in the data to create a blank line in dialog blocks.
.It 'l'
provides the content of a lyric line. The line is rendered in italic. If
the line is long enough to be wrapped by the formatter, the paragraph formed
has a hanging indent.
.It 't'
provides the content of a transition directive.
.El
.Ss CONTENT
Nellie discards data outside of terminal elements.  You can place comments
in between terminal elements.
.Pp
Inside of terminal elements, nellie normalizes whitespace by converting all
whitespace characters into space characters, collapsing multiple contiguous
spaces into single spaces, and removing leading and trailing spaces.
.Pp
Nellie underlines words bookended with underscores.  If you want to
underline a section of text, you must _underline_ _each_ _word_
_individually_.  _Underline_-_each_-_word_-_in_-_a_-hyphenate._
You cannot underline metadata for the title page.
.Pp
Nellie automatically renders Act, End, and Scene headings in bold and lyric
lines in italics. Nellie provides no means for you to change the font.  To
emphasize words, underline them.
.Pp
To insert [, ], or \\ into element content, escape each with a backslash:
.Bd -literal -offset left
[a[He looks up. \\[At what?\\]]]
.Pp
To indicate elision at the front of words, use a backtick: in the `hood.
In PDFs, the backtick is replaced with a typewriter apostrophe.  In EPUBs,
the backtick is replaced with a single typographical apostrophe.
.Pp
Non-ASCII characters can be entered as ASCII backslash escape sequences.
To insert the following escape sequences into TSML elements, escape the
backslash with another backslash: \\\\'e.  You do not have to do this in
the human-friendly markup language.
.Pp
\\' followed by an upper or lowercase vowel inserts the utf-8 character
sequence for that vowel with an acute accent.
.Pp
\\` inserts grave-accented vowels.
.Pp
\\^ inserts circumflex-accented vowels.
.Pp
\\: inserts diaresis/trema/umlaut-accented vowels and upper and lowercase Ys.
.Pp
\\~ inserts only upper and lowercase Ns with tildes.
.Pp
\\, inserts only upper and lowercase Cs with cedillas.
.Pp
\\u followed by a decimal number inserts a Unicode character by code point.
If the code point is immediately followed by digits that are part of the
document text, those digits must be represented by \\u escapes, or the
digits will be interpreted as part of the code point.
.Ss MARKUP LANGUAGE
As a convenience for humans, Nellie converts a minimal human-friendly
markup language into TSML.  The markup language is derived from the
Fountain markup language but is not entirely compatible with Fountain.
.Pp
A separate text file describes the markup language in detail.
Nellie.txt is installed in %%PATH%%.
.Pp
The process of producing a PDF file from a markup file can be automated
with a Makefile:
.Bd -literal -offset left
all: screenplay.pdf

screenplay.pdf: screenplay.tsml
   nellie screenplay.tsml screenplay.pdf

screenplay.tsml: screenplay.txt
   nellie -c screenplay.txt screenplay.tsml
.Ed
.Ss EPUB
If you use -i, you must manually copy two PNG images into the ebook/OEBPS
directory.
.Pp
The first image file must be named cover1.png.  This is the external cover
image.  I suggest that you create an image of 2560px height by 1600px width.
.Pp
The second image must be named cover2.png and contain no more than 4
megapixels.  Note that this limit is specified in pixels not bytes.  The
internal image should be a scaled-down version of the external image.  I
suggest that you create an image of 1600px height by 1000px width.
.Pp
Zip up the ebook directory to form an EPUB document:
.Bd -literal -offset left
cd ebook
zip -X ../screenplay.epub mimetype
zip -r ../screenplay.epub META-INF OEBPS
cd ..
rm -r ebook
.Ed
.Pp
The process of converting a markup file into TSML and then into an ebook
can be automated with a Makefile:
.Bd -literal -offset left
all: screenplay.epub

screenplay.epub: screenplay.tsml
   nellie -e screenplay.tsml
   cd ebook && zip -X ../screenplay.epub mimetype && zip -r ../screenplay.epub META-INF OEBPS
   rm -r ebook

screenplay.tsml: screenplay.txt
   nellie -c screenplay.txt screenplay.tsml
.Ed
.Sh AUTHORS
.An James Bailie Aq bailie9@icloud.com
.br
mammothcheese.ca
