.Dd Sun Nov 16, 2025
.Dt prospero 1
.Sh NAME
.Nm Prospero
.Nd Minimal Event-Driven HTTPS/1.1 Server
.Sh SYNOPSIS
.Nm prospero -r Ao server-root Ac -f Ao config-file Ac Oo -l -s -w -n -b Ao buffer-size Ac -c Ao cache-timeout Ac -i Ao interface Ac -q Ao queue-length Ac -m Ao max-conns Ac -o Ao idle-timeout Ac -u Ao user Ac -g Ao group Ac -a Ao language Ac Oc
.Sh DESCRIPTION
Prospero is a minimal, secure, event-driven web server.
.Ss PROSPERO SUPPORTS:
.Pp
.Bl -bullet
.It
IPv4 and IPv6 connections.
.It
TLS 1.3 encrypted traffic only.
.It
Kernel TLS for maximum performance.
.It
Enough of HTTP/1.1 to be functional with all browsers.
.It
WebSocket forwarding for up to 5 local or remote WebSocket servers.
.It
SCGI forwarding for up to 5 local or remote SCGI application servers.
.El
.Pp
.Ss PROSPERO DOES NOT SUPPORT:
.Bl -bullet
.It
Connections to any port but 80 or 443.
.It
Insecure traffic.
.It
OCSP stapling.  That ship has sailed.  Only Firefox still validates.
.It
Graceful stops.  The server exits soon after receiving SIGTERM.
.It
Name-based virtual hosting.
.It
HTTP/2 or HTTP/3.  These unnecessarily complex protocols provide little benefit
for small websites.
.It
Plain CGI.
.It
Access authentication.
.It
Content negotiation beyond "If-Modified-Since", "If-Unmodified-Since", and
single "Range" requests for "bytes" of static resources.
.It
Etags
.It
Directory listings.
.It
The ~user notation in URLS.
.El
.Ss INSECURE REQUESTS
Prospero redirects the first request on a connection to port 80 to port 443
via a "301 Permanently moved" response.  Prospero then closes the
connection.
.Ss CROSS-ORIGIN REQUESTS
Prospero rejects HTTP/1.1 requests for files without "Referer" or "Origin"
header lines that do not match Prospero's hostname unless the requested
resources' filenames end in:
.Bd -literal -offset left
 \.html
 \.webmanifest
 \.txt
 \.pdf
 \.epub
 \.bz
 \.bz2
 \.tgz
 \.txz
 \.gz
 \.gzip
 \.zip
.Ed
.Pp
Prospero will service requests for .png files without "Referer" or
"Origin" headers for the following filenames only:
.Bd -literal -offset left
android-chrome-192x192.png
android-chrome-512x512.png
apple-touch-icon.png
favicon-16x16.png
favicon-32x32.png
.Ed
.Pp
Requests for files whose filenames do not have a suffix separated from the
rest of the filename by a dot '.' are only successful if the requests have
Referer or Origin headers and the requests are not cross-origin requests.
Responses containing such files will be identified as text files with
Content-Type: text/plain; charset=utf-8.
.Pp
By default, cross-origin checking is not performed for SCGI application
servers or WebSocket servers.  To turn on cross-origin checking for SCGI
requests, include the -s option on the command line.  To turn on
cross-origin checking for WebSocket servers, include -w on the command
line.
.Ss CONTENT TYPES
Files served by prospero reside in the directory specified by the -r option.
.Pp
Files must be owned and readable by the user specified by the -u option or
by the group specified by the -g option.  Note that Prospero will refuse to
serve a file owned by another user or group even if the file is
world-readable.  Prospero will refuse to serve a file marked executable.
.Pp
The filename-suffix-to-type mappings are described in
.Bd -literal -offset left
/usr/local/share/prospero/content-types.txt
.Ed
.Pp
To add or modify mappings, edit the file appropriately.  Each filename
suffix must appear by itself on a line.  The type to which the suffix maps
must follow on the next line.  Blank lines are ignored.  Each suffix in the
file must be unique.  If multiple instances of the same suffix appear in
the file, only the first instance is recognized.  You must restart the
server for your modifications to take effect.
.Ss CACHE-CONTROL
Prospero adds a
.Bd -literal -offset left
Cache-Control: max-age=600, must-revalidate
.Ed
.Pp
header to all responses except file responses whose Content-Type in
content-types.txt begins with "font/".
.Pp
You can alter the default value of 600 seconds with the -c option.
.Pp
This header is overridden by Cache-Control headers provided by SCGI
servers.
.Pp
The -n option prevents prospero from adding a Cache-Control directive to
SCGI response headers that do not contain a Cache-Control directive.  The
server will continue to pass-through any Cache-Control directive that the
SCGI server provides.
.Ss SYSTEM CONFIGURATION
Place the following lines in /etc/sysctl.conf and reboot.  The 2 files values
determine the maximum number of open files system-wide and per-process.
Prospero uses two descriptors for every connection that it services. The 3
subsequent options turn on Kernel TLS for maximum performance.
.Bd -literal -offset left
kern.maxfiles=262144
kern.maxfilesperproc=131072
kern.ipc.mb_use_ext_pgs=1
kern.ipc.tls.ifnet.permitted=1
kern.ipc.tls.enable=1
.Ed
.Ss SERVER START AND STOP
.Pp
If you do not want to run prospero as user www in group www, you need to
manually chown(8) the executable appropriately.
.Pp
Prospero writes its pid into /var/run/prospero.pid.
.Pp
A rc.d script is installed in /usr/local/etc/rc.d/.  Add the following
lines to /etc/rc.conf to start prospero on system boot.  Replace the items in
brackets with values appropriate for your system.  These are the minimal
set of options you should start with.  The available options are described
in full at the end of this manual page.
.Pp
If the server exits prematurely, it writes an error message to
/var/log/messages before exiting.
.Bd -literal -offset left
prospero_enable="YES"
prospero_flags="-r <server-root> -f <config-file> -u <user> -g <group>"
.Ed
.Pp
Start, stop, or restart prospero, or determine if it is running with the
following commands.
.Bd -literal -offset left
service prospero start
service prospero stop
service prospero restart
service prospero status
.Ed
.Pp
If you do not want prospero started on system start, set
.Bd -literal -offset left
prospero_enable="NO"
.Ed
.Pp
and use the following commands.
.Bd -literal -offset left
service prospero onestart
service prospero onestop
service prospero onerestart
service prospero onestatus
.Ed
.Ss PERCENT ESCAPES
In the resource names of requests, prospero converts every sequence
of bytes consisting of a percent sign followed by two hexadecimal digits
into the byte specified by the hexadecimal value.  Whitespace and percent
signs must all be percent-escaped to be recognized in resource names.
.Ss TLS CONFIGURATION
The TLS configuration is described in a text file.  The -f command line
option must be set to the filename of the configuration file.  The file
must contain from 4 to 10 newline-terminated lines of text.  The first 4
lines describe, in order:
.Bl -enum
.It
The hostname for which Prospero serves content.  This line may be blank
to cause the server to take the hostname from the system hostname.  In
requests, prospero recognizes the hostname with or without the "www"
subdomain.  Do not include the "www" subdomain in the hostname.
.It
The absolute path to the file containing the server's TLS key.
.It
The TLS key password.  This line can be blank if there is no password.
.It
The absolute path to the file containing the TLS certificate chain.
.El
.Pp
The next 10 lines are optional, and if present, define up to 5 SCGI
application servers and 5 WebSocket servers to which Prospero will forward
requests.  The 5th, 7th, 9th, 11th, and 13th lines define WebSocket
servers.  The 6th, 8th, 10th, 12th, and 14th lines define SCGI application
servers.
.Pp
Any of these lines can be blank to indicate that no server is defined.  For
example, if you want to define WebSocket servers but no SCGI application
servers, leave the SCGI server lines between the WebSocket lines blank.
Blank lines at the end of the configuration file are unnecessary.  There is
no need to include blank lines after the last non-blank server line.
.Pp
Note that local servers can listen on the loopback address, but this
degrades performance by unnecessarily interposing the TCP/IP stack between
Prospero and the servers.
.Ss WEBSOCKET SERVERS
The lines defining Websocket servers consist of the absolute path to a UNIX
socket for a local WebSocket Server or a remote server specification of the
form <hostname or IP addr>:<port>. 
.Pp
NOTE: if the address is in IPv6 format, you MUST NOT enclose it in square
brackets. Because the port number is always required in server specifications,
the last component separated by a colon is always unabiguously the port
specification. If you enclose an IPv6 address in square brackets, prospero will
fail to connect to the server.
.Pp
Note that connections to a remote server are not encrypted.  Connect only
to hosts on your LAN.
.Pp
To be recognized as a WebSocket upgrade, a request must begin with 1 of the
following paths: /websocket/, /websocket2/, /websocket3/, /websocket4/, or
/websocket5/.  Requests beginning with /websocket/ are forwarded to the
server defined on line 5.  Requests beginning with /websocket2/ are
forwarded to the server defined on line 7.  Requests beginning with
/websocket3/ are forwarded to the server defined on line 9.  Requests
beginning with /websocket4/ are forwarded to the server defined on line 11.
Requests beginning with /websocket5/ are forwarded to the server defined on
line 13.
.Ed
.Pp
When a client initiates a WebSocket upgrade, prospero performs the
WebSocket handshake and then connects to the WebSocket server.  Propero
ignores Sec-WebSocket-Protocol headers.  Clients must NOT specify a
protocol, or handshakes may not complete successfully with all browsers.
.Pp
Prospero then sends to the WebSocket server the content of the Cookie
header line submitted with the upgrade request.  The cookie is terminated
with a single newline.  The cookie line is empty if the client did not
submit a Cookie header.
.Pp
From then on, prospero transfers data back and forth between the WebSocket
server and the client.  The client and WebSocket server are responsible for
framing and unframing data.
.Ss SCGI APPLICATION SERVERS
The lines defining SCGI applications servers consist of the absolute path
to a UNIX socket for a local SCGI application server or a remote server
specification of the form <hostname or IP addr>:<port>.
.Pp
NOTE: if the address is in IPv6 format, you MUST NOT enclose it in square
brackets. Because the port number is always required in server specifications,
the last component separated by a colon is always unabiguously the port
specification. If you enclose an IPv6 address in square brackets, prospero will
fail to connect to the server.
.Pp
Note that connections to remote servers are not encrypted.  Connect only to
hosts on your LAN.
.Pp
To be recognized as a SCGI request, a request must begin with 1 of the
following paths: /scgi/, /scgi2/, /scgi3/, /scgi4/, or /scgi5/.  Requests
beginning with /scgi/ are forwarded to the server defined on line 6.
Requests beginning with /scgi2/ are forwarded to the server defined on line
8.  Requests beginning with /scgi3/ are forwarded to the server defined on
line 10.  Requests beginning with /scgi4/ are forwarded to the server
defined on line 12.  Requests beginning with /scgi5/ are forwarded to the
server defined on line 14.
.Pp
The following environment variables are set for the SCGI server:
.Bd -literal -offset left
CONTENT_TYPE
CONTENT_LENGTH
REQUEST_METHOD
QUERY_STRING
SCRIPT_NAME
HTTP_REFERRER
HTTP_ORIGIN
HTTP_COOKIE
HTTP_IF_MODIFIED_SINCE
HTTP_IF_UNMODIFIED_SINCE
HTTP_SEC_GPC
HTTP_USER_AGENT
LOCAL_ADDR
REMOTE_ADDR
.Ed
.Pp
The LOCAL_ADDR variable contains the textual representation of the address
of the interface on which the client is connected to prospero.  This
variable is only set if the -s option is not present on the command line.
The variable's value can be used by SCGI servers that need to perform their
own cross-origin checks to verify HTTP_ORIGIN or HTTP_REFERRER values that
contain IP addresses instead of hostnames.  Note that IP4 addresses will be
in compact IP6-mapped form.  That is to say that the addresses will begin
with the sequence ::ffff:
.Pp
Prospero does not pass on every response header line generated by the SCGI
application.  Prospero plucks out the content of the:
.Bd -literal -offset left
Content-Type
Content-Length
Content-Disposition
Cache-Control
Location
Set-Cookie x 5
.Ed
.Pp
header lines and formats its own response header.  Only the "Content-Type"
header line is necessary.  If it is missing, Prospero inserts
"Content-Type: text/plain; charset=utf-8" into the response header.
.Pp
Responses from the SCGI server that contain a "Location" header line are
formatted into "303 see other" responses.  Those responses must not contain
bodies.  All other SCGI server responses are formatted into "200 OK"
responses and must contain bodies.  This means that error messages must be
delivered to the client as HTML.
.Ss COMMAND-LINE OPTIONS
The following options are recognized.
.Bl -tag -width "-r"
.It -r
The -r option is mandatory and specifies the server root directory.  The
root resource must be named "index.html".
.Pp
Requests for paths that end with the directory separator are interpreted as
requests for "index.html" in the directories specified by those paths.
Requests for directories that are not terminated with the directory
separator are interpreted as requests for files and fail.
.Pp
To prevent clients from learning about the file system, prospero pretends
not to "see" file system entities in the following situations.  In each of
these situations, prospero returns a 404 Not Found response.
.Bl -bullet
.It
On receipt of a request for an existing non-regular file.
.It
On receipt of a request for an existing executable file.
.It
On receipt of a request for an existing regular file to which the server
does not have read permission.
.It
On receipt of a request for an existing regular file that is not owned the
user defined by the -u option or is not in the group defined by the -g
option regardless of the file's permissions.
.El
.It -f
The -f option is mandatory and specifies the TLS configuration file.
.It -a
The -a option specifies the language code to be delivered in Content-Language
response header lines. Because Prospero does not support content negotiation
based on Accept-Language request header lines, only one language code should be
present in the argument for the -a option. Individual HTML pages can specify a
language to override the language specified (ie., <html lang="de">). If the -a
option is not set, a Content-Language response header is not delivered to
clients.
.It -b
The -b option specifies the size of the internal buffers used by Prospero
to transfer data to and from clients.  The default value is 1024 bytes.
This value is the server's multiplexing quantum.  The server will attempt
to read or write no more than this quantity of bytes of data at one time.
This value must be a multiple of 2 occuring in the inclusive range
1024-65534.
.Pp
Prospero reads request headers line-by-line.  The value of the -b option
must be large enough to accommodate the longest single line of request
headers.  If a single request header line is too big, prospero considers
the client to be hostile and drops the connection without explanation.
.Pp
Prospero reads response headers from SCGI servers line-by-line.  The value
of the -b option must be large enough to accommodate the longest single
line of SCGI response headers.  If a single response header line is too
big, prospero closes the connection to the SCGI server, logs an error
message, and sends a 500 Internal Server Error to the client.
.It -c
The -c option is used to change the value of the cache timeout returned to
clients in Cache-Control headers.  This value defaults to 600 seconds for a
timeout of 10 minutes.
.It -s
The -s option turns on cross-origin checking for SCGI servers.  If you want
your servers to be accessible only by referral from links on your site, add
-s to your options.  Otherwise, cross-origin requests for SCGI server URLs
are not rejected.  If you want to have a mix of both behaviors, your
applications servers must perform their own cross-origin checking.
.It -w
The -w option turns on cross-origin checking for WebSocket servers.
.It -n
The -n option prevents the server from adding a Cache-Control header to
SCGI server responses that do not contain one.
.It -m
The -m option specifies the maximum number of simultaneous connections
that prospero services.  If not set, prospero maintains no more than 50000
simultaneous connections.
.It -l
The -l option turns on request logging.  If -l is specified, prospero
maintains a log of client requests in Extended Log File Format in
/var/log/prospero.log.
.Pp
The fields included in log lines are:
.Bd -literal -offset left
date time c-ip cs(User-Agent) cs(Origin) cs(Referer) cs-method cs-uri
.Ed
.Pp
The client port number is included with the client IP address.  IPv6 and
IPv6-mapped IPv4 addresses are wrapped in square brackets to distinguish
those addresses from IPv4 addresses and to distinguish IPv6 addresses
from their associated port numbers.
.Pp
To have newsyslog(8) rotate the log at midnight and archive the last 7 days
of logs compressed with gzip, add:
.Bd -literal -offset left
/var/log/prospero.log www:www 660 7 * @T00 BZ /var/run/prospero.pid
.Ed
.Pp
to the file:
.Bd -literal -offset left
/usr/local/etc/newsyslog.conf.d/newsyslog.conf
.Ed
.Pp
Create the directories and file as necessary.  If  you want to use bzip2
compression instead of gzip, replace Z with J.
.Pp
Consult newsyslog.conf(5) for more information.
.It -i
The -i option limits prospero to accepting connections only from a specified
interface.  Supply the IP address of the desired interface as argument.  By
default, prospero accepts connections on all interfaces capable of IPv4 or
IPv6.
.It -o
The -o option sets the idle connection timeout value.  This value is the
number of seconds after which idle connections are closed.  An idle
connection is one on which no data has been transferred to or from the
client for the timeout value of seconds.  The default timeout value is 30
seconds.
.Pp
Prospero does not timeout WebSocket connections.  WebSocket servers are
responsible for timing-out their connections.
.It -q
The -q option sets the number of incoming connections queued by the
operating system for the server.  The queue defaults to 2048 connections.
Increasing this value may help the server cope with high demand if the
server is dropping connections.
.It -u
.It -g
The -u and the -g options specify the user and group that the server
switches to after establishing the listening sockets.  If not specified,
both values default to "nobody".
.El
.Sh AUTHORS
.An James Bailie Aq bailie9@icloud.com
.br
http://www.mammothcheese.ca
