#!/bin/sh

if [ "$#" -ne 4 ]; then
   echo "Usage: tmpfs.sh <user> <group> <source directory> <mount point>"
   exit 1;
fi

USR=$1
GRP=$2
SOURCE=$3
DEST=$4

/bin/mkdir -p ${DEST}
/sbin/mount -t tmpfs tmpfs ${DEST}
/bin/chmod 750 ${DEST}
/bin/cp -r ${SOURCE}/* ${DEST}
/usr/sbin/chown -R ${USR}:${GRP} ${DEST}
